#ifndef _PARTIAL_ORDER_H_
#define _PARTIAL_ORDER_H_

#ifndef NOREDUCE

#define C3LIVENESSSTACK     1
#define C3LIVENESSDUPLICATE 2
#define C3SAFETYSTACK       3
#define C3SAFETYDUPLICATE   4
#define C3STATIC            5
#define C3IGNORE            6
#define C3QUEUE             7
#define DEFAULT_C3          0
unsigned char Selected_C3;

#define DEFAULT_FILTER_TRAIL 0
unsigned char Filter_Trail;

#define AMPLEH_NONE    0
#define AMPLEH_BEST    1
#define AMPLEH_MEAN    2
#define AMPLEH_SUCCS   3
#define DEFAULT_AMPLEH 0
unsigned char Selected_Ample_Heuristic;

void init_po(void);
StateItem* reduce(State *s, StateItem *successors);
short ample(State *s, StateItem *successors);
int check_C1_C2(State *s, short pid);
int check_C0_C3(State *s, short pid, StateItem *successors);
int visible(Trans *t);
void print_C3_conditions();
void print_ampleh();
int eval_ample(short pid, StateItem *successors);
State** eliminate_irrelevant_trans(State **trail, int *length);

int sticky(Trans *t);
void init_static_po();

/* Statistics */
int reductions=0;
int full_expansions=0;
int C0_fails=0;
int C1C2_fail=0;
int C3_fails=0;
void po_statistics();

#endif // NOREDUCE  

#endif // _PARTIAL_ORDER_H_
