#ifndef _SYMMETRY_H_
#define _SYMMETRY_H_

#ifdef SYMMETRY
#include "hashtable.h"

void canonicalize_successors(StateItem *successors);
void canonicalize_state(State *state);
int rotate(State* state);
void apply_swap(PackedState *state, int i, int j);
void permute_scalar(int size, State *tmp, State *min);
int lexicographically_smaller(State *s1, State *s2);
unsigned char symmetry;

int orbit_states;
HashTable *ErrorOrbit;
void construct_error_orbit(State *state);

#ifndef SYMMOD
PackedState* full_zeta(PackedState *); /* implemented in symmetric-fsm.c */
PackedState* full2_zeta(PackedState *); /* implemented in symmetric-fsm.c */
PackedState* zeta(PackedState *); /* implemented in span-sym.c */
#endif //


#define DEFAULT_SYMMETRY 0

#endif // SYMMETRY

#endif // SYMMETRY_H
