// ..
//  Copyright (c) 1996-1998 University Freiburg, Computer Science Departement
// 
//  Project:  HsfLight - Heuristic Search Framework Light
//             
//  See file README for information on using and copying this software.
// 
//  Module:   /home/edelkamp/cdot/alg/hsfLight/include/ac_automat.h
//  Author:   Stefan Edelkamp
//  eMail:    edelkamp@informatik.uni-freiburg.de 
//  WWW:      http://www.informatik.uni-freiburg.de/edelkamp/~hsfLight
// ..

#ifndef AC_AUTOMATON_H
#define AC_AUTOMATON_H

#include <stdio.h>
#include <assert.h>
#include <Moves.h>
#include <Queue.h>

// -----------------------------------------------------------------------
//                         Definition
// -----------------------------------------------------------------------

const int MAXINT = 2147483647;

class AC_Automat {
public:
  int** TT;       // automaton table, < 0 = accepting
  int** Goto;     // trie table, < 0 = accepting 
  Moves** link;    // if accepting, link to corresponding duplicate
  int* failure;    // the failure func in Aho and Coarsic 
  int size;       // number of states
  int number;     // number of duplicates
  int undefined;  // undefined = MAXINT
  Moves* mhead;   // head of double linked list
  Queue<int> Q;   // Queue for bfs construction
  int maxfsm;
  int maxmoves;
  int maxg;
 
  AC_Automat(int _maxfsm, int _maxmoves, int _maxg);
  ~AC_Automat();

  int Search(Moves* m);
  member(Moves* m);
  remove(Moves* m);
  insert(Moves* _m);
  dfa();
  
  int get_size() { return size; }
  int get_number() { return number; }
  loadmoves (char filename[]);
  savemoves(char filename[]);
  loadgoto (char filename[]); 
  savegoto (char filename[]);
  loadfsm (char filename[]);
  savefsm (char filename[]);
  print() const; 
  
  friend ostream& operator<<(ostream& os, const AC_Automat& m) { m.print(); }
    
};

#endif //
