// ..
//  Copyright (c) 1996-1998 University Freiburg, Computer Science Departement
// 
//  Project:  HsfLight - Heuristic Search Framework Light
//             
//  See file README for information on using and copying this software.
// 
//  Module:   /home/edelkamp/cdot/alg/hsfLight/include/HashTable.h
//  Author:   Stefan Edelkamp
//  eMail:    edelkamp@informatik.uni-freiburg.de 
//  WWW:      http://www.informatik.uni-freiburg.de/edelkamp/~hsfLight
// ..

#ifndef __BITSTATE_HASH_TABLE_H__
#define __BITSTATE_HASH_TABLE_H__

#include <stdio.h>                                 
#include <stdlib.h>
#include <Global.h>
#include <Debug.h>


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

class BitStateHashTable {
 public:
  State** bucket;   // pointer to first element in table with given hash val
  int offset;
  int size;
  int max;
  
  BitStateHashTable(int m);
  init();
  ~BitStateHashTable();
  hash(PackedState& ps);
  State* search (PackedState& ps);
  insert (State *S); 
  State* search (PackedState& ps, int hashval);
  insert (State *S, int hashval); 
};


BitStateHashTable::BitStateHashTable(int m): offset(0), size(0), max(m) { 
  bucket = new State*[max];
  for(int i=0; i<max; i++) bucket[i]=(State *)0;
}

BitStateHashTable::init(){
  offset = size = 0;
  for(int i=0; i<max; i++){
    if(bucket[i]) delete bucket[i];
    bucket[i]=(State *)0;
  }
}

BitStateHashTable::~BitStateHashTable() {
  for(int i=0; i<max; i++){
    if(bucket[i]) delete bucket[i];
    bucket[i]=(State *)0;
  }
  delete bucket;
}

BitStateHashTable::hash(PackedState& ps) {
  return  PackedState::hash(ps,max);
}      

State *BitStateHashTable::search (PackedState& ps) {
  int hashval;

  hashval=this->hash(ps);
  if(bucket[hashval])
    return bucket[hashval];
  else
    return (State *)0;
}

BitStateHashTable::insert (State *S) {
  int hashval;

  hashval=this->hash(*(S->ps));
  if(!bucket[hashval]){
    size++;
    bucket[hashval]=S;
  }
}

State *BitStateHashTable::search (PackedState& ps, int hashval) {
  if(bucket[hashval])
    return bucket[hashval];
  else
    return (State *)0;
}

BitStateHashTable::insert (State *S, int hashval) {
  if(!bucket[hashval]){
    size++;
    bucket[hashval]=S;
  }
}

#endif //

