// ..
//  Copyright (c) 1996-1998 University Freiburg, Computer Science Departement
// 
//  Project:  HsfLight - Heuristic Search Framework Light
//             
//  See file README for information on using and copying this software.
// 
//  Module:   /home/edelkamp/cdot/alg/hsfLight/include/HashTable.h
//  Author:   Stefan Edelkamp
//  eMail:    edelkamp@informatik.uni-freiburg.de 
//  WWW:      http://www.informatik.uni-freiburg.de/edelkamp/~hsfLight
// ..

#ifndef __BITSTATE_HASH_TABLE2_H__
#define __BITSTATE_HASH_TABLE2_H__

#include <stdio.h>                                 
#include <stdlib.h>
#include <Global.h>
#include <Debug.h>


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

class BitStateHashTable2 {
 public:
  BitState** bucket;   // pointer to first element in table with given hash val
  int offset;
  int size;
  int max;
  
  BitStateHashTable2(int m);
  init();
  ~BitStateHashTable2();
  hash(PackedState& ps);
  State* search (PackedState& ps);
  insert (State *S); 
  State* search (PackedState& ps, int hashval);
  insert (State *S, int hashval); 
};


BitStateHashTable2::BitStateHashTable2(int m): offset(0), size(0), max(m) { 
  bucket = new BitState*[max];
  for(int i=0; i<max; i++) bucket[i]=(BitState *)0;
}

BitStateHashTable2::init(){
  offset = size = 0;
  for(int i=0; i<max; i++){
    if(bucket[i]) delete bucket[i];
    bucket[i]=(BitState *)0;
  }
}

BitStateHashTable2::~BitStateHashTable2() {
  for(int i=0; i<max; i++){
    if(bucket[i]) delete bucket[i];
    bucket[i]=(BitState *)0;
  }
  delete bucket;
}

BitStateHashTable2::hash(PackedState& ps) {
  return  PackedState::hash(ps,max);
}      

State *BitStateHashTable2::search (PackedState& ps) {
  int hashval;

  hashval=this->hash(ps);
  if(bucket[hashval])
    return (State *)bucket[hashval];
  else
    return (State *)0;
}

BitStateHashTable2::insert (State *S) {
  int hashval;

  hashval=this->hash(*(S->ps));
  if(!bucket[hashval]){
    size++;
    bucket[hashval]=new BitState;
    *bucket[hashval]=*S;
    delete S;
  }
}

State *BitStateHashTable2::search (PackedState& ps, int hashval) {
  if(bucket[hashval])
    return (State *)bucket[hashval];
  else
    return (State *)0;
}

BitStateHashTable2::insert (State *S, int hashval) {
  if(!bucket[hashval]){
    size++;
    bucket[hashval]=new BitState;
    *bucket[hashval]=*S;
  }
}

#endif //

