// ..
//  Copyright (c) 1996-1998 University Freiburg, Computer Science Departement
// 
//  Project:  HsfLight - Heuristic Search Framework Light
//             
//  See file README for information on using and copying this software.
// 
//  Module:   /home/edelkamp/cdot/alg/hsfLight/include/Debug.h
//  Author:   Stefan Edelkamp
//  eMail:    edelkamp@informatik.uni-freiburg.de 
//  WWW:      http://www.informatik.uni-freiburg.de/edelkamp/~hsfLight
// ..

#ifndef DEBUG_H
#define DEBUG_H

#include <iostream.h>                               /* standard I/O library */

template<class H>
static Swap(H& a, H& b) {H temp = a; a = b; b = temp; };


// -----------------------------------------------------------------------

// #define DBG_SHOW_MESSAGES

#ifdef DBG_SHOW_MESSAGES
#define DBG(msg) cout << "DBG\\" << __FILE__ << '\\' << __LINE__ << "\t:  " << msg << '\n'  
#else
#define DBG(msg)
#endif //

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

// #define STATISTICS

#ifdef STATISTICS
#define STATS(msg) cout << "STATS\\" << __FILE__ << '\\' << __LINE__ << "\t:  " << msg << '\n'  
#else
#define STATS(msg)
#endif //

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

// #define SOLUTION

#ifdef SOLUTION
#define SOLS(msg) cout << "SOLS\\" << __FILE__ << '\\' << __LINE__ << "\t:  " << msg << '\n'  
#else
#define SOLS(msg)
#endif //

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

// #define SEARCHING

#ifdef SEARCHING
#define SEARCH(msg) cout << "SEARCH\\" << __FILE__ << '\\' << __LINE__ << "\t:  " << msg << '\n'  
#else
#define SEARCH(msg)
#endif //

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

// #define LEARNING

#ifdef LEARNING
#define LEARN(msg) cout << "SEARCH\\" << __FILE__ << '\\' << __LINE__ << "\t:  " << msg << '\n'  
#else
#define LEARN(msg)
#endif //

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

#define ERROR_SHOW_MESSAGES

#ifdef ERROR_SHOW_MESSAGES
#define ERR(msg) cout << "ERR\\" << __FILE__ << '\\' << __LINE__ << "\t:  " << msg << '\n'  
#else
#define ERR(msg)
#endif //

// -----------------------------------------------------------------------

#endif //
